/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import CH.ifa.draw.util.ColorMap;
import DE.siemens.ad.logo.util.Language;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class ColorRenderer
extends JPanel
implements ListCellRenderer {
    public static final String ADDITIONAL_COLORS = "additionalColors";
    protected JPanel fColorPreviewPanel;
    public JLabel fColorNameLabel;

    public ColorRenderer() {
        this.setLayout(new GridBagLayout());
        this.fColorPreviewPanel = new JPanel(null);
        this.fColorPreviewPanel.setPreferredSize(new Dimension(20, 13));
        this.fColorPreviewPanel.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 5, 2, 5);
        this.add((Component)this.fColorPreviewPanel, gbc);
        this.fColorNameLabel = new JLabel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        this.add((Component)this.fColorNameLabel, gbc);
    }

    public String getColorName(String colorKey) {
        if (colorKey.equals(ADDITIONAL_COLORS)) {
            return Language.getString("color.additionalColors", "Additional colors...");
        }
        if (ColorMap.isUserdefinedColor(colorKey)) {
            return Language.getString("color.userDefined", "Userdefined color");
        }
        return Language.getString(colorKey, colorKey);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        String colorKey = (String)value;
        Color selectedColor = ColorMap.color(colorKey);
        this.fColorPreviewPanel.setForeground(selectedColor);
        this.fColorPreviewPanel.setBackground(selectedColor);
        this.fColorPreviewPanel.setVisible(!colorKey.equals(ADDITIONAL_COLORS));
        String farbName = this.getColorName(colorKey);
        this.fColorNameLabel.setText(farbName);
        Color colorSelectionBackground = (Color)UIManager.get("List.selectionBackground");
        Color colorSelectionForeground = (Color)UIManager.get("List.selectionForeground");
        if (isSelected) {
            this.setBackground(colorSelectionBackground);
            this.setForeground(list.getSelectionForeground());
            this.fColorNameLabel.setBackground(colorSelectionBackground);
            this.fColorNameLabel.setForeground(colorSelectionForeground);
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            this.fColorNameLabel.setBackground(list.getBackground());
            this.fColorNameLabel.setForeground(list.getForeground());
        }
        return this;
    }

    public void paintComponent(Graphics g) {
        this.validate();
        super.paintComponent(g);
    }
}

